/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.video.test;

import emulator.EmulatorException;
import emulator.GUI.display.VicScreen;
import emulator.hardware.bus.VideoBus;
import emulator.hardware.memory.MemoryBlock;
import emulator.hardware.video.Vic6561;
import emulator.hardware.video.test.CountingClock;
import emulator.hardware.video.test.NullClock;
import emulator.hardware.video.test.NullDisplay;

public class TestVic {
    public static void main(String[] args) {
        double time_ms;
        long diff;
        long now;
        NullClock clock = new NullClock();
        CountingClock counting_clock = new CountingClock();
        MemoryBlock memory = new MemoryBlock(65536);
        Vic6561 vic = new Vic6561();
        NullDisplay null_display = new NullDisplay();
        VicScreen display_1x1 = new VicScreen(1, 208, 1, 260);
        VicScreen display_3x2 = new VicScreen(3, 624, 2, 520);
        vic.attach(new VideoBus(memory), counting_clock);
        System.out.println("Counting cycles per frame");
        try {
            vic.refreshDisplay(null_display);
            System.out.println("Counted ticks: " + counting_clock.getCounterValue() + "  " + "Ticks for resolution: 284x312/4 =" + 22152);
        }
        catch (EmulatorException e1) {
            e1.printStackTrace();
        }
        vic.attach(new VideoBus(memory), clock);
        int cycles = 10;
        System.out.println("Performance test without display");
        try {
            now = System.nanoTime();
            int i = 0;
            while (i < cycles) {
                vic.refreshDisplay(null_display);
                ++i;
            }
            diff = System.nanoTime() - now;
            time_ms = (double)diff / 1000000.0 / (double)cycles;
            System.out.println("elapsed time: " + time_ms + " ms  " + (int)(1000.0 / time_ms) + " Hz");
        }
        catch (EmulatorException e) {
            e.printStackTrace();
        }
        System.out.println("Performance test with 1x1 display");
        try {
            now = System.nanoTime();
            int i = 0;
            while (i < cycles) {
                vic.refreshDisplay(display_1x1);
                ++i;
            }
            diff = System.nanoTime() - now;
            time_ms = (double)diff / 1000000.0 / (double)cycles;
            System.out.println("elapsed time: " + time_ms + " ms  " + (int)(1000.0 / time_ms) + " Hz");
        }
        catch (EmulatorException e) {
            e.printStackTrace();
        }
        System.out.println("Performance test with 3x2 display");
        try {
            long now2 = System.nanoTime();
            int i = 0;
            while (i < cycles) {
                vic.refreshDisplay(display_3x2);
                ++i;
            }
            long diff2 = System.nanoTime() - now2;
            time_ms = (double)diff2 / 1000000.0 / (double)cycles;
            System.out.println("elapsed time: " + time_ms + " ms  " + (int)(1000.0 / time_ms) + " Hz");
        }
        catch (EmulatorException e) {
            e.printStackTrace();
        }
    }
}

